let currentSlide = 0;
let slideInterval;

function initSlider() {
  const slides = document.querySelectorAll('.slide-item');
  const indicators = document.getElementById('indicators');
  
  if (slides.length === 0) return;

  if (indicators) {
    indicators.innerHTML = '';
    for (let i = 0; i < slides.length; i++) {
      const indicator = document.createElement('div');
      indicator.className = 'indicator' + (i === 0 ? ' active' : '');
      indicator.addEventListener('click', () => goToSlide(i));
      indicators.appendChild(indicator);
    }
  }

  const prevBtn = document.getElementById('prevBtn');
  const nextBtn = document.getElementById('nextBtn');

  if (prevBtn) {
    prevBtn.addEventListener('click', () => {
      currentSlide = (currentSlide - 1 + slides.length) % slides.length;
      updateSlider();
      resetInterval();
    });
  }

  if (nextBtn) {
    nextBtn.addEventListener('click', () => {
      currentSlide = (currentSlide + 1) % slides.length;
      updateSlider();
      resetInterval();
    });
  }

  startInterval();
}

function updateSlider() {
  const slides = document.querySelectorAll('.slide-item');
  const indicators = document.querySelectorAll('.indicator');

  slides.forEach((slide, index) => {
    if (index === currentSlide) {
      slide.classList.add('active');
    } else {
      slide.classList.remove('active');
    }
  });

  indicators.forEach((indicator, index) => {
    if (index === currentSlide) {
      indicator.classList.add('active');
    } else {
      indicator.classList.remove('active');
    }
  });
}

function goToSlide(index) {
  currentSlide = index;
  updateSlider();
  resetInterval();
}

function startInterval() {
  slideInterval = setInterval(() => {
    const slides = document.querySelectorAll('.slide-item');
    currentSlide = (currentSlide + 1) % slides.length;
    updateSlider();
  }, 3000);
}

function resetInterval() {
  clearInterval(slideInterval);
  startInterval();
}

if (document.readyState === 'loading') {
  document.addEventListener('DOMContentLoaded', initSlider);
} else {
  initSlider();
}

